/// Advantage ADO.NET Provider Command Builder Demo
/// This is a simple application to demonstrate how the 
/// capabilities of the command builder. The application
/// is for demonstartion purposes, and is not written in 
/// a style that a programmer would typically follow.
 

using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using Advantage.Data.Provider;

namespace CmdBldDemo
{
	/// <summary>
	/// Summary description for CmdBldForm.
	/// </summary>
	public class CmdBldForm : System.Windows.Forms.Form
	{
      private System.Windows.Forms.Button m_updateButton;
      private System.Windows.Forms.Button m_deleteButton;
      private System.Windows.Forms.Button m_insertButton;
      private System.Windows.Forms.DataGrid m_dataGrid;
      private System.Windows.Forms.Button m_exitButton;
      private System.Windows.Forms.Label cmdLabel;
      private System.Windows.Forms.Label selLabel;
      private System.Windows.Forms.Label csLabel;
      private System.Windows.Forms.Label dsLabel;
      private System.Windows.Forms.TextBox m_commandTextBox;
      private System.Windows.Forms.TextBox m_selectTextBox;
      private System.Windows.Forms.TextBox m_connectTextBox;
      private System.Windows.Forms.CheckBox m_checkOnlyPKInWhere;
      private System.Windows.Forms.CheckBox m_checkRequirePK;
      private System.Windows.Forms.CheckBox m_checkSetPrefixSuffix;
      private System.Windows.Forms.Button m_getDataButton;
      private System.Windows.Forms.Button m_setDataButton;
      private AdsConnection m_connection = null;
      private AdsDataAdapter m_adapter = null;
      private AdsCommandBuilder m_cmdBuilder = null;
      private DataSet m_dataSet = null;
      private static string defaultConnection = "data source = ;tabletype = ads_adt;servertype = ;";
      private static string defaultSelect = "SELECT * FROM ";

      /// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public CmdBldForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

         // Default to static strings - user must complete
         m_connectTextBox.Text = defaultConnection;
         m_selectTextBox.Text = defaultSelect;
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if ( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
         this.m_commandTextBox = new System.Windows.Forms.TextBox();
         this.m_updateButton = new System.Windows.Forms.Button();
         this.m_deleteButton = new System.Windows.Forms.Button();
         this.m_insertButton = new System.Windows.Forms.Button();
         this.m_dataGrid = new System.Windows.Forms.DataGrid();
         this.m_getDataButton = new System.Windows.Forms.Button();
         this.m_setDataButton = new System.Windows.Forms.Button();
         this.m_exitButton = new System.Windows.Forms.Button();
         this.m_selectTextBox = new System.Windows.Forms.TextBox();
         this.cmdLabel = new System.Windows.Forms.Label();
         this.selLabel = new System.Windows.Forms.Label();
         this.csLabel = new System.Windows.Forms.Label();
         this.dsLabel = new System.Windows.Forms.Label();
         this.m_connectTextBox = new System.Windows.Forms.TextBox();
         this.m_checkRequirePK = new System.Windows.Forms.CheckBox();
         this.m_checkOnlyPKInWhere = new System.Windows.Forms.CheckBox();
         this.m_checkSetPrefixSuffix = new System.Windows.Forms.CheckBox();
         ((System.ComponentModel.ISupportInitialize)(this.m_dataGrid)).BeginInit();
         this.SuspendLayout();
         // 
         // m_commandTextBox
         // 
         this.m_commandTextBox.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
         this.m_commandTextBox.Enabled = false;
         this.m_commandTextBox.Location = new System.Drawing.Point(128, 176);
         this.m_commandTextBox.Multiline = true;
         this.m_commandTextBox.Name = "m_commandTextBox";
         this.m_commandTextBox.Size = new System.Drawing.Size(432, 88);
         this.m_commandTextBox.TabIndex = 11;
         this.m_commandTextBox.Text = "";
         // 
         // m_updateButton
         // 
         this.m_updateButton.Location = new System.Drawing.Point(128, 144);
         this.m_updateButton.Name = "m_updateButton";
         this.m_updateButton.Size = new System.Drawing.Size(144, 23);
         this.m_updateButton.TabIndex = 7;
         this.m_updateButton.Text = "Show &Update Command";
         this.m_updateButton.Click += new System.EventHandler(this.m_updateButton_Click);
         // 
         // m_deleteButton
         // 
         this.m_deleteButton.Location = new System.Drawing.Point(280, 144);
         this.m_deleteButton.Name = "m_deleteButton";
         this.m_deleteButton.Size = new System.Drawing.Size(136, 23);
         this.m_deleteButton.TabIndex = 8;
         this.m_deleteButton.Text = "Show &Delete Command";
         this.m_deleteButton.Click += new System.EventHandler(this.m_deleteButton_Click);
         // 
         // m_insertButton
         // 
         this.m_insertButton.Location = new System.Drawing.Point(424, 144);
         this.m_insertButton.Name = "m_insertButton";
         this.m_insertButton.Size = new System.Drawing.Size(136, 23);
         this.m_insertButton.TabIndex = 9;
         this.m_insertButton.Text = "Show &Insert Command";
         this.m_insertButton.Click += new System.EventHandler(this.m_insertButton_Click);
         // 
         // m_dataGrid
         // 
         this.m_dataGrid.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
         this.m_dataGrid.DataMember = "";
         this.m_dataGrid.HeaderForeColor = System.Drawing.SystemColors.ControlText;
         this.m_dataGrid.Location = new System.Drawing.Point(8, 288);
         this.m_dataGrid.Name = "m_dataGrid";
         this.m_dataGrid.Size = new System.Drawing.Size(552, 244);
         this.m_dataGrid.TabIndex = 13;
         // 
         // m_getDataButton
         // 
         this.m_getDataButton.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
         this.m_getDataButton.Location = new System.Drawing.Point(8, 540);
         this.m_getDataButton.Name = "m_getDataButton";
         this.m_getDataButton.Size = new System.Drawing.Size(112, 24);
         this.m_getDataButton.TabIndex = 14;
         this.m_getDataButton.Text = "&Get Data (Fill)";
         this.m_getDataButton.Click += new System.EventHandler(this.m_getDataButton_Click);
         // 
         // m_setDataButton
         // 
         this.m_setDataButton.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
         this.m_setDataButton.Enabled = false;
         this.m_setDataButton.Location = new System.Drawing.Point(128, 540);
         this.m_setDataButton.Name = "m_setDataButton";
         this.m_setDataButton.Size = new System.Drawing.Size(112, 23);
         this.m_setDataButton.TabIndex = 15;
         this.m_setDataButton.Text = "&Set Data (Update)";
         this.m_setDataButton.Click += new System.EventHandler(this.m_setDataButton_Click);
         // 
         // m_exitButton
         // 
         this.m_exitButton.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
         this.m_exitButton.DialogResult = System.Windows.Forms.DialogResult.Cancel;
         this.m_exitButton.Location = new System.Drawing.Point(504, 540);
         this.m_exitButton.Name = "m_exitButton";
         this.m_exitButton.Size = new System.Drawing.Size(56, 24);
         this.m_exitButton.TabIndex = 16;
         this.m_exitButton.Text = "E&xit";
         this.m_exitButton.Click += new System.EventHandler(this.m_exitButton_Click);
         // 
         // m_selectTextBox
         // 
         this.m_selectTextBox.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
         this.m_selectTextBox.Location = new System.Drawing.Point(128, 80);
         this.m_selectTextBox.Name = "m_selectTextBox";
         this.m_selectTextBox.Size = new System.Drawing.Size(432, 20);
         this.m_selectTextBox.TabIndex = 3;
         this.m_selectTextBox.Text = "";
         // 
         // cmdLabel
         // 
         this.cmdLabel.Location = new System.Drawing.Point(16, 176);
         this.cmdLabel.Name = "cmdLabel";
         this.cmdLabel.Size = new System.Drawing.Size(88, 16);
         this.cmdLabel.TabIndex = 10;
         this.cmdLabel.Text = "Command:";
         // 
         // selLabel
         // 
         this.selLabel.Location = new System.Drawing.Point(16, 80);
         this.selLabel.Name = "selLabel";
         this.selLabel.Size = new System.Drawing.Size(112, 16);
         this.selLabel.TabIndex = 2;
         this.selLabel.Text = "Select Command:";
         // 
         // csLabel
         // 
         this.csLabel.Location = new System.Drawing.Point(16, 16);
         this.csLabel.Name = "csLabel";
         this.csLabel.Size = new System.Drawing.Size(104, 16);
         this.csLabel.TabIndex = 0;
         this.csLabel.Text = "Connection String:";
         // 
         // dsLabel
         // 
         this.dsLabel.Location = new System.Drawing.Point(8, 272);
         this.dsLabel.Name = "dsLabel";
         this.dsLabel.Size = new System.Drawing.Size(88, 16);
         this.dsLabel.TabIndex = 12;
         this.dsLabel.Text = "Data Set:";
         // 
         // m_connectTextBox
         // 
         this.m_connectTextBox.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
         this.m_connectTextBox.Location = new System.Drawing.Point(128, 8);
         this.m_connectTextBox.Multiline = true;
         this.m_connectTextBox.Name = "m_connectTextBox";
         this.m_connectTextBox.Size = new System.Drawing.Size(432, 64);
         this.m_connectTextBox.TabIndex = 1;
         this.m_connectTextBox.Text = "";
         this.m_connectTextBox.TextChanged += new System.EventHandler(this.m_connectTextBox_TextChanged);
         // 
         // m_checkRequirePK
         // 
         this.m_checkRequirePK.Checked = true;
         this.m_checkRequirePK.CheckState = System.Windows.Forms.CheckState.Checked;
         this.m_checkRequirePK.Location = new System.Drawing.Point(128, 104);
         this.m_checkRequirePK.Name = "m_checkRequirePK";
         this.m_checkRequirePK.Size = new System.Drawing.Size(136, 16);
         this.m_checkRequirePK.TabIndex = 4;
         this.m_checkRequirePK.Text = "Require Primary Key";
         // 
         // m_checkOnlyPKInWhere
         // 
         this.m_checkOnlyPKInWhere.Location = new System.Drawing.Point(272, 104);
         this.m_checkOnlyPKInWhere.Name = "m_checkOnlyPKInWhere";
         this.m_checkOnlyPKInWhere.Size = new System.Drawing.Size(160, 16);
         this.m_checkOnlyPKInWhere.TabIndex = 5;
         this.m_checkOnlyPKInWhere.Text = "PK only in WHERE clause";
         // 
         // m_checkSetPrefixSuffix
         // 
         this.m_checkSetPrefixSuffix.Location = new System.Drawing.Point(440, 104);
         this.m_checkSetPrefixSuffix.Name = "m_checkSetPrefixSuffix";
         this.m_checkSetPrefixSuffix.Size = new System.Drawing.Size(120, 16);
         this.m_checkSetPrefixSuffix.TabIndex = 6;
         this.m_checkSetPrefixSuffix.Text = "No Prefix/Suffix";
         // 
         // CmdBldForm
         // 
         this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
         this.ClientSize = new System.Drawing.Size(568, 573);
         this.Controls.Add(this.m_checkSetPrefixSuffix);
         this.Controls.Add(this.m_checkOnlyPKInWhere);
         this.Controls.Add(this.m_checkRequirePK);
         this.Controls.Add(this.m_connectTextBox);
         this.Controls.Add(this.m_selectTextBox);
         this.Controls.Add(this.m_commandTextBox);
         this.Controls.Add(this.dsLabel);
         this.Controls.Add(this.cmdLabel);
         this.Controls.Add(this.selLabel);
         this.Controls.Add(this.csLabel);
         this.Controls.Add(this.m_exitButton);
         this.Controls.Add(this.m_setDataButton);
         this.Controls.Add(this.m_getDataButton);
         this.Controls.Add(this.m_dataGrid);
         this.Controls.Add(this.m_insertButton);
         this.Controls.Add(this.m_deleteButton);
         this.Controls.Add(this.m_updateButton);
         this.Name = "CmdBldForm";
         this.SizeGripStyle = System.Windows.Forms.SizeGripStyle.Show;
         this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
         this.Text = "Advantage Command Builder Demo";
         this.Closing += new System.ComponentModel.CancelEventHandler(this.CmdBldForm_Closing);
         ((System.ComponentModel.ISupportInitialize)(this.m_dataGrid)).EndInit();
         this.ResumeLayout(false);

      }
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new CmdBldForm());
		}

      // Create a temporary command builder and retrieve the UPDATE command
      private void m_updateButton_Click( object sender, System.EventArgs e )
      {
         // Make sure we have connection string and select command
         if ( CheckMissingData() )
            return;
         try 
         {
            // Open the connection (if not already)
            CheckOpened();
            // Show that we're doing something
            Cursor = Cursors.WaitCursor;
            // Create a new adapter and command builder
            AdsDataAdapter adapter = new AdsDataAdapter(m_selectTextBox.Text, m_connection );
            AdsCommandBuilder cb = new AdsCommandBuilder(adapter);
            // Set command builder properties
            GetCheckboxInfo( cb );
            // Display the UPDATE command
            m_commandTextBox.Text = cb.GetUpdateCommand().CommandText;
         }
         catch ( Exception ex ){ ShowException( ex ); }
         Cursor = Cursors.Default;
      }

      // Create a temporary command builder and retrieve the DELETE command
      private void m_deleteButton_Click( object sender, System.EventArgs e )
      {
         // Make sure we have connection string and select command
         if ( CheckMissingData() )
            return;
         try 
         {
            // Open the connection (if not already)
            CheckOpened();
            // Show that we're doing something
            Cursor = Cursors.WaitCursor;
            // Create a new adapter and command builder
            AdsDataAdapter adapter = new AdsDataAdapter( m_selectTextBox.Text, m_connection );
            AdsCommandBuilder cb = new AdsCommandBuilder( adapter );
            // Set command builder properties
            GetCheckboxInfo( cb );
            // Display the DELETE command
            m_commandTextBox.Text = cb.GetDeleteCommand().CommandText;
         }
         catch ( Exception ex ){ ShowException( ex ); }
         Cursor = Cursors.Default;
      }

      // Create a temporary command builder and retrieve the INSERT command
      private void m_insertButton_Click( object sender, System.EventArgs e )
      {
         // Make sure we have connection string and select command
         if ( CheckMissingData() )
            return;
         try 
         {
            // Open the connection (if not already)
            CheckOpened();
            // Show that we're doing something
            Cursor = Cursors.WaitCursor;
            // Create a new adapter and command builder
            AdsDataAdapter adapter = new AdsDataAdapter( m_selectTextBox.Text, m_connection );
            AdsCommandBuilder cb = new AdsCommandBuilder( adapter );
            // Set command builder properties
            GetCheckboxInfo( cb );
            // Display the INSERT command
            m_commandTextBox.Text = cb.GetInsertCommand().CommandText;
         }
         catch ( Exception ex ){ ShowException( ex ); }
         Cursor = Cursors.Default;
      }

      // Set the command builder properties accordingly before building commands
      private void GetCheckboxInfo( AdsCommandBuilder cb )
      {
         cb.RequirePrimaryKey = m_checkRequirePK.Checked;
         cb.UsePKOnlyInWhereClause = m_checkOnlyPKInWhere.Checked;
         if ( m_checkSetPrefixSuffix.Checked )
         {
            cb.QuotePrefix = "";
            cb.QuoteSuffix = "";
         }
      }

      // If we don't have a connection opened, open one. 
      private void CheckOpened()
      {
         if ( m_connection != null && 
              m_connection.State == ConnectionState.Open )
            return;
         try
         {
            // Expect to always be null here
            if ( m_connection == null )
               m_connection = new AdsConnection( m_connectTextBox.Text );
            else
            {
               ConnectionState s = m_connection.State;
            }
            m_connection.Open();
         }
         catch ( Exception ex )
         {
            ShowException( ex ); 
         }
      }

      // If the connection string is modified, close any existing connection
      private void m_connectTextBox_TextChanged( object sender, System.EventArgs e )
      {
         if ( m_connection != null )
         {
            m_connection.Close();
            m_connection.Dispose();
            m_connection = null;
         }  
      } 

      // Close our connection before we leave
      private void CmdBldForm_Closing( object sender, System.ComponentModel.CancelEventArgs e )
      {
         try
         {
            if ( m_connection != null )
               m_connection.Close();
         }
         catch ( Exception ex ){ ShowException( ex ); }
      }

      // Retrieve data into data set and set to grid
      private void m_getDataButton_Click( object sender, System.EventArgs e )
      {
         // Make sure we have connection string and select command
         if ( CheckMissingData() )
            return;
         try
         {
            // Open the connection (if not already)
            CheckOpened();

            // Dispose any existing objects
            if ( m_adapter != null )
               m_adapter.Dispose();
            if ( m_dataSet != null )
               m_dataSet.Dispose();
            if ( m_cmdBuilder != null )
               m_cmdBuilder.Dispose();

            // Start with new adapter and dataset - quick and lazy
            m_adapter = new AdsDataAdapter( m_selectTextBox.Text, m_connection );
            m_dataSet = new DataSet();
           
            // Retrieve data
            m_adapter.Fill( m_dataSet);
            m_dataGrid.DataSource = m_dataSet.Tables[0];

            // Do some formatting for better (hopefully) display 
            FormatDateTimeColumns();
            AutoSizeColumns();

            // Get our command builder ready
            m_cmdBuilder = new AdsCommandBuilder(m_adapter);
            GetCheckboxInfo(m_cmdBuilder);
            m_setDataButton.Enabled = true;
         }
         catch ( Exception ex ){ ShowException( ex ); }
      }

      // Update the source with any changes to the data set
      private void m_setDataButton_Click( object sender, System.EventArgs e )
      {
         try
         {
            // Update any changes to command builder properties
            GetCheckboxInfo( m_cmdBuilder );
            // Update changes to the Data Set back on the Table.
            m_adapter.Update( m_dataSet );
         }
         catch ( Exception ex ){ ShowException( ex ); }
      }

      // Show Date AND Time fields on DataTime columns (defaults to date)
      private void FormatDateTimeColumns()
      {
         DataTable table = (DataTable)m_dataGrid.DataSource;
         DataGridTableStyle style = null;
         m_dataGrid.TableStyles.Clear();
         CurrencyManager cm = 
               (CurrencyManager)BindingContext[m_dataSet, table.TableName];
         style = new DataGridTableStyle(cm);
         m_dataGrid.TableStyles.Add(style);
         for ( int i=0; i<table.Columns.Count; i++ )
         {
            DataColumn col = table.Columns[i];
            if ( col.DataType == typeof(System.DateTime))
            {
               DataGridColumnStyle cstyle = 
                  m_dataGrid.TableStyles[0].GridColumnStyles[i];
               if ( (cstyle != null) && 
                    (cstyle.GetType() == typeof(DataGridTextBoxColumn)) )
                  ((DataGridTextBoxColumn)cstyle).Format = "G";
            }
            else
            {
               DataGridTextBoxColumn tbcol = new DataGridTextBoxColumn();
               style.GridColumnStyles.Add( tbcol );
            }
         } 
         m_dataGrid.TableStyles.Add( style );
      }

      // Adjust column sizes for readability
      private void AutoSizeColumns() 
      { 
         if ( m_dataGrid.TableStyles.Count == 0 )
            return; //should have set style
         Graphics graphics = Graphics.FromHwnd( m_dataGrid.Handle ); 
         StringFormat format = new StringFormat( StringFormat.GenericTypographic ); 

         DataTable table = (DataTable)m_dataGrid.DataSource;
         for ( int col=0; col<table.Columns.Count; col++ )
         {
            SizeF size; 
            size = graphics.MeasureString( table.Columns[col].ToString(), 
                                           m_dataGrid.Font, 500, format ); 
            float width = size.Width; 
            for ( int row = 0; row < table.Rows.Count; row++ )
            { 
               size = graphics.MeasureString( m_dataGrid[row, col].ToString(), 
                                              m_dataGrid.Font, 500, format ); 
               if ( size.Width > width ) 
                  width = size.Width; 
            }
            m_dataGrid.TableStyles[0].GridColumnStyles[col].Width = (int)width+8;
         } 
         graphics.Dispose(); 
      }

      // Make sure we have connection string and select command
      // If otherwise invalid strings are used, we'll get exception when used
      private bool CheckMissingData()
      {
         if( m_connectTextBox.Text.Length == 0 || 
             m_connectTextBox.Text == defaultConnection ) 
         {
            MessageBox.Show("Connection String invalid.", "Connection Error");
            m_connectTextBox.Focus();
            return true;
         }
         if( m_selectTextBox.Text.Length == 0 ||
             m_selectTextBox.Text == defaultSelect ) 
         {
            MessageBox.Show("Select Command invalid.", "Command Error");
            m_selectTextBox.Focus();
            return true;
         }
         return false;
      }

      // Display an exception message
      private void ShowException( Exception ex )
      {
         MessageBox.Show("Caught Exception:" + ex.ToString(), "Error",
            MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
      }

      // Exit
      private void m_exitButton_Click(object sender, System.EventArgs e)
      {
         Close();
      }
 	}
}
